/*******************************************************
Filename		:  create_storetw.sql
Release 		:  c2.0.2, C2.0.4
SIR			:  1586
Description		:  Create schema STORETW
Author			:  Ganesh Thadkamalla/Joseph Wilson
Date			:  1/22/2004
Comments		:  6/9/03 -- Added explicit grants to storetw on storet and storet1 tables.
			   6/20/03 -- revoke create session
			   8/11/03 -- added materialized view grants -JW
			   1/22/04 -- split storetw creation into 3 scripts -JW
	02/04/2005 - moved revoke create session to calling script. -GT
**********************************************************/
spool create_storetw.log
--connect system/sto2et@storet.sdc
--DROP USER STORETW CASCADE ;
CREATE USER "STORETW"  PROFILE "DEFAULT" IDENTIFIED BY "storetw" 
    DEFAULT 
    TABLESPACE "STORETDATA" TEMPORARY 
    TABLESPACE "TEMPORARY_DATA" QUOTA UNLIMITED 
    ON STORETdata QUOTA UNLIMITED 
    ON STORETINDX ACCOUNT UNLOCK;
grant CREATE SESSION to storetw;


--DROP USER STORETWEB CASCADE ;
CREATE USER "STORETWEB"  PROFILE "DEFAULT" IDENTIFIED BY "storetweb" 
    DEFAULT 
    TABLESPACE "STORETDATA" TEMPORARY 
    TABLESPACE "TEMPORARY_DATA" QUOTA UNLIMITED 
    ON STORETdata QUOTA UNLIMITED 
    ON STORETINDX ACCOUNT UNLOCK;
grant CREATE SESSION to storetweb;
grant CREATE SYNONYM to storetweb;


grant ALTER SESSION to storetw;
grant CREATE CLUSTER to storetw;
grant CREATE INDEXTYPE to storetw;
grant CREATE OPERATOR to storetw;
grant CREATE PROCEDURE to storetw;
grant CREATE SEQUENCE to storetw;
grant CREATE SESSION to storetw;
grant CREATE SYNONYM to storetw;
grant CREATE TABLE to storetw;
grant CREATE TRIGGER to storetw;
grant CREATE TYPE to storetw;
grant CREATE VIEW to storetw;
grant create materialized view to storetw;
grant query rewrite to storetw;
grant create session to storet, storet1;
GRANT EXP_FULL_DATABASE, IMP_FULL_DATABASE TO STORETW;

-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;
-- Coalesce storetdata and storetindx tablespaces;
alter tablespace storetdata coalesce;
alter tablespace storetindx coalesce;

spool off;